package demo.module;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import netsdk.lib.DeviceSdk;
import netsdk.lib.ToolKits;
import netsdk.struct.*;


/**
 * \if ENGLISH_LANG
 * Device Control Interface
 * contains:reboot device、setup device time and query device time
 * \else
 * 设备控制接口实现
 * 包含: 重启、时间同步、获取时间功能
 * \endif
 */
public class DeviceControlModule {
    
	/**
	 * \if ENGLISH_LANG
	 * Reboot Device
	 * \else
	 * 重启设备
	 * \endif
	 */
    public static boolean reboot() {
    	
        if (!LoginModule.netsdk.NET_SDK_RebootDVR(LoginModule.m_hLoginHandle)) {
        	System.err.println("CLIENT_ControlDevice Failed!" + ToolKits.getErrorCodePrint());
    		return false;
        }
        return true;
    }

    /**
	 * \if ENGLISH_LANG
	 * Setup Device Time
	 * \else
	 * 时间同步
	 * \endif
	 */
    public static boolean setTime(String date) {
    	long deviceTime = 0l;
    	SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    	if (date == null) {   		
            date = dateFormat.format(new java.util.Date());           
    	}
    	Date _date;
		try {
			_date = dateFormat.parse(date);
			deviceTime = _date.getTime()/1000;
		} catch (ParseException e) {
			e.printStackTrace();
		}          	
        if (!LoginModule.netsdk.NET_SDK_ChangTime(LoginModule.m_hLoginHandle, deviceTime)) {
    		System.err.println("CLIENT_SetupDeviceTime Failed!" + ToolKits.getErrorCodePrint());
    		return false;
        }
        return true;
    }
    
    /**
  	 * \if ENGLISH_LANG
  	 * Get Device Current Time
  	 * \else
  	 * 获取设备当前时间
  	 * \endif
  	 */
    public static String getTime() {
    	DD_TIME.ByReference deviceTime = new DD_TIME.ByReference();
    	
    	if (!LoginModule.netsdk.NET_SDK_GetDeviceTime(LoginModule.m_hLoginHandle, deviceTime)) {
    		System.err.println("CLIENT_QueryDeviceTime Failed!" + ToolKits.getErrorCodePrint());
    		return null;
    	}

    	String date = deviceTime.toStringTime();
    	date = date.replace("/", "-");
    	
    	return date;
    }
}
